<?php
require_once 'ControlDB.php';
class ControlProduto {
	
	public function pegarTodosCategoria() {
		$categoria = new Categoria();
                $categoria->orderBy('ordem');
		$categoria->find();
		return $categoria;
	}
        
	
	public function pegarUmCategoria($pk, $idsite = '') {
		$categoria = new Categoria();
                if ($idsite == '')
                {
                    $categoria->get($pk);
                } else {
                    $categoria->setIdsite($idsite);
                    $categoria->find(true);
                }
		return $categoria;
	}
	
	public function salvarCategoria(Categoria $categoria) {
		$categoria->save();
		return 1;
	}
	
	public function excluirCategoria(Categoria $categoria) {
		$categoria->delete();
                return 1;
	}
        
        //Produto
        
        public function pegarTodosProduto() {
		$produto = new Produto();
                //$produto->orderBy('ordem desc');
		$produto->find();
		return $produto;
	}
        
        public function pegarTodosProdutoHabilitado() {
		$produto = new Produto();
                $produto->setHabilitado(true);
                //$produto->orderBy('ordem desc');
		$produto->find();
		return $produto;
	}
        
        public function pegarTodosProdutoporCategoria(Categoria $categoria, $categoriaID = '') {
		$produto = new Produto();
                $produtoCategoria = new Produtocategoria();
                if ($categoriaID == '')
                {
                    $categoriaID = $categoria->getCategoriaid();
                }
                $produto->alias('p')->join($produtoCategoria, 'INNER', 'c', 'produtoid', 'produtoid','c.categoriaid = ' . $categoriaID)->find();
                return $produto;
	}
	
	public function pegarUmProduto($pk, $idsite = '') {
		$produto = new Produto();
		if ($idsite == '')
                {
                    $produto->get($pk);
                } else {
                    $produto->setIdsite($idsite);
                    $produto->find(true);
                }
		return $produto;
	}
	
	public function salvarProduto(Produto $produto) {
		$produto->save();
		return 1;
	}
	
	public function excluirProduto(Produto $produto) {
            
                $produtoCategoria = $produto->getProdutocategorias();
                foreach ($produtoCategoria as $key => $row)
                {
                    $this->excluirProdutoCategoria($row);
                }
                $produtoDescricao = $produto->getProdutodescricoes();
                foreach ($produtoDescricao as $key => $row)
                {
                    $this->excluirProdutoDescricao($row);
                }
		$produto->delete();
                return 1;
	}
        
        //ProdutoCategoria
        public function pegarTodosProdutoCategoria() {
		$produtoCategoria = new ProdutoCategoria();
		$produtoCategoria->find();
		return $produtoCategoria;
	}
        
        public function pegarTodosProdudoCategoriaporProduto($pk) {
		$produtoCategoria = new Produtocategoria();
                $produtoCategoria->setProdutoid($pk);
		$produtoCategoria->find();
		return $produtoCategoria;
	}
	
	public function pegarUmProdutoCategoria($pk) {
		$produtoCategoria = new Produtocategoria();
		$produtoCategoria->get($pk);
		return $produtoCategoria;
	}
	
	public function salvarProdutoCategoria(ProdutoCategoria $produtoCategoria) {
		$produtoCategoria->save();
		return 1;
	}
	
	public function excluirProdutoCategoria(ProdutoCategoria $produtoCategoria) {
			$produtoCategoria->delete();
			return 1;
	}
        
        public function excluirProdutoCategoriaporID($produtoCategoriaid) {
			$produtoCategoria->delete();
			return 1;
	}
        
        //ProdutoDescricao
          public function pegarTodosProdutoDescricao() {
		$produtoDescricao = new ProdutoDescricao();
		$produtoDescricao->find();
		return $produtoDescricao;
	}
        
        public function pegarTodosProdudoDescricaoporProduto($pk) {
		$produtoDescricao = new Produtodescricao();
                $produtoDescricao->setProdutoid($pk);
		$produtoDescricao->find();
		return $produtoDescricao;
	}
	
	public function pegarUmProdutoDescricao($pk) {
		$produtoDescricao = new Produtodescricao();
		$produtoDescricao->get($pk);
		return $produtoDescricao;
	}
	
	public function salvarProdutoDescricao(ProdutoDescricao $produtoDescricao) {
		$produtoDescricao->save();
		return 1;
	}
	
	public function excluirProdutoDescricao(ProdutoDescricao $produtoDescricao) {
			$produtoDescricao->delete();
			return 1;
	}
}
?>