<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "area"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Area extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'area';
    protected $_package   = 'Domain';
    
    
    public $areaid;
    public $descricao;
    public $texto;
    public $texto1;
    public $titulo;
    
    
    /**
     * get areaid
     *
     */
    public function getAreaid() {
    	return $this->areaid;
    }
    
    /**
     * set areaid
     * @param Type $value
     *
     */
    public function setAreaid($value) {
    	$this->areaid = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get texto
     *
     */
    public function getTexto() {
    	return $this->texto;
    }
    
    /**
     * set texto
     * @param Type $value
     *
     */
    public function setTexto($value) {
    	$this->texto = $value;
    }
    
    /**
     * get texto1
     *
     */
    public function getTexto1() {
    	return $this->texto1;
    }
    
    /**
     * set texto1
     * @param Type $value
     *
     */
    public function setTexto1($value) {
    	$this->texto1 = $value;
    }
    
    /**
     * get titulo
     *
     */
    public function getTitulo() {
    	return $this->titulo;
    }
    
    /**
     * set Titulo
     * @param Type $value
     *
     */
    public function setTitulo($value) {
    	$this->titulo = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("areaid", "areaid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("descricao", "descricao", "varchar", 300, array());
        $this->_addField("texto", "texto", "int", 11, array('notnull' => true, 'formatter' => array('Area', 'gTexto')));
        $this->_addField("texto1", "texto1", "int", 11, array('formatter' => array('Area', 'gTexto1')));
        $this->_addField("titulo", "titulo", "varchar", 100, array('notnull' => true));

        
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Area
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Area;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE

        public $lang;
        
    public function gTexto() {
        return Idiomas::getTexto($this->texto, $this->lang);
    }

    public function sTexto($value) {
        $this->texto = Idiomas::setTexto($this->texto, $this->lang, $value);
    }
    
    public function gTexto1() {
        return Idiomas::getTexto($this->texto1, $this->lang);
    }

    public function sTexto1($value) {
        $this->texto1 = Idiomas::setTexto($this->texto1, $this->lang, $value);
    }

}
