<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "artigoTipo"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Artigotipo extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'artigoTipo';
    protected $_package   = 'Domain';
    
    
    public $artigotipoid;
    public $nome;
    public $habilitado;
    public $artigos = array();
    
    
    /**
     * get artigotipoid
     *
     */
    public function getArtigotipoid() {
    	return $this->artigotipoid;
    }
    
    /**
     * set artigotipoid
     * @param Type $value
     *
     */
    public function setArtigotipoid($value) {
    	$this->artigotipoid = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    /**
     * get artigos
     *
     */
    public function getArtigos() {
    	return $this->artigos;
    }
    
    /**
     * set artigos
     * @param Type $value
     *
     */
    public function setArtigos($value) {
    	$this->artigos = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("artigotipoid", "artigotipoid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true, 'formatter' => array('Artigotipo', 'gNome')));
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Artigotipo', 'gHabilitadoSimNao')));

        
        $this->_addForeignRelation("artigos", self::ONE_TO_MANY, "Artigo", "artigotipoid", null, null, null);
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Artigotipo
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Artigotipo;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
        public $lang;
        
    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    } 
    
    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }

}
