<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "contatodepartamento"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Contatodepartamento extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'contatodepartamento';
    protected $_package   = 'Domain';
    
    
    public $contatodepartamentoid;
    public $nome;
    public $email;
    public $telefone;
    public $ramal;
    public $habilitado;
    
    
    /**
     * get contatodepartamentoid
     *
     */
    public function getContatodepartamentoid() {
    	return $this->contatodepartamentoid;
    }
    
    /**
     * set contatodepartamentoid
     * @param Type $value
     *
     */
    public function setContatodepartamentoid($value) {
    	$this->contatodepartamentoid = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get email
     *
     */
    public function getEmail() {
    	return $this->email;
    }
    
    /**
     * set email
     * @param Type $value
     *
     */
    public function setEmail($value) {
    	$this->email = $value;
    }
    /**
     * get telefone
     *
     */
    public function getTelefone() {
    	return $this->telefone;
    }
    
    /**
     * set telefone
     * @param Type $value
     *
     */
    public function setTelefone($value) {
    	$this->telefone = $value;
    }
    /**
     * get ramal
     *
     */
    public function getRamal() {
    	return $this->ramal;
    }
    
    /**
     * set ramal
     * @param Type $value
     *
     */
    public function setRamal($value) {
    	$this->ramal = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("contatodepartamentoid", "contatodepartamentoid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true, 'formatter' => array('Contatodepartamento', 'gNome')));
        $this->_addField("email", "email", "varchar", 250, array('notnull' => true));
        $this->_addField("telefone", "telefone", "varchar", 60, array());
        $this->_addField("ramal", "ramal", "varchar", 60, array());
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Contatodepartamento', 'gHabilitadoSimNao')));

        
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Contatodepartamento
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Contatodepartamento;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE

        
        public $lang;
        
    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    } 
        
        public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }

}
