<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "foto"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Foto extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'foto';
    protected $_package   = 'Domain';
    
    
    public $fotoid;
    public $galeriaid;
    public $descricao;
    public $ordem;
    public $fotoq;
    public $foto;
    public $habilitado;
    
    
    /**
     * get fotoid
     *
     */
    public function getFotoid() {
    	return $this->fotoid;
    }
    
    /**
     * set fotoid
     * @param Type $value
     *
     */
    public function setFotoid($value) {
    	$this->fotoid = $value;
    }
    /**
     * get galeriaid
     *
     */
    public function getGaleriaid() {
    	return $this->galeriaid;
    }
    
    /**
     * set galeriaid
     * @param Type $value
     *
     */
    public function setGaleriaid($value) {
    	$this->galeriaid = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get ordem
     *
     */
    public function getOrdem() {
    	return $this->ordem;
    }
    
    /**
     * set ordem
     * @param Type $value
     *
     */
    public function setOrdem($value) {
    	$this->ordem = $value;
    }
    /**
     * get fotoq
     *
     */
    public function getFotoq() {
    	return $this->fotoq;
    }
    
    /**
     * set fotoq
     * @param Type $value
     *
     */
    public function setFotoq($value) {
    	$this->fotoq = $value;
    }
    /**
     * get foto
     *
     */
    public function getFoto() {
    	return $this->foto;
    }
    
    /**
     * set foto
     * @param Type $value
     *
     */
    public function setFoto($value) {
    	$this->foto = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("fotoid", "fotoid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("galeriaid", "galeriaid", "int", 11, array('notnull' => true, 'foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'galeriaid', 'class' => 'Galeria'));
        $this->_addField("descricao", "descricao", "int", 11, array('formatter' => array('Foto', 'gDescricao')));
        $this->_addField("ordem", "ordem", "int", 11, array());
        $this->_addField("fotoq", "fotoq", "varchar", 250, array('notnull' => true));
        $this->_addField("foto", "foto", "varchar", 250, array('notnull' => true));
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Foto', 'gHabilitadoSimNao')));

        
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Foto
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Foto;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
        public $lang;
        
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    } 
    
    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }


}
