<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "galeria"
 * in 2013-08-29
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Galeria extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'galeria';
    protected $_package   = 'Domain';
    
    
    public $galeriaid;
    public $nome;
    public $descricao;
    public $ordem;
    public $fotoq;
    public $foto;
    public $habilitado;
    public $artigos = array();
    public $fotos = array();
    public $produtos = array();
    
    
    /**
     * get galeriaid
     *
     */
    public function getGaleriaid() {
    	return $this->galeriaid;
    }
    
    /**
     * set galeriaid
     * @param Type $value
     *
     */
    public function setGaleriaid($value) {
    	$this->galeriaid = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get ordem
     *
     */
    public function getOrdem() {
    	return $this->ordem;
    }
    
    /**
     * set ordem
     * @param Type $value
     *
     */
    public function setOrdem($value) {
    	$this->ordem = $value;
    }
    /**
     * get fotoq
     *
     */
    public function getFotoq() {
    	return $this->fotoq;
    }
    
    /**
     * set fotoq
     * @param Type $value
     *
     */
    public function setFotoq($value) {
    	$this->fotoq = $value;
    }
    /**
     * get foto
     *
     */
    public function getFoto() {
    	return $this->foto;
    }
    
    /**
     * set foto
     * @param Type $value
     *
     */
    public function setFoto($value) {
    	$this->foto = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    /**
     * get artigos
     *
     */
    public function getArtigos() {
    	return $this->artigos;
    }
    
    /**
     * set artigos
     * @param Type $value
     *
     */
    public function setArtigos($value) {
    	$this->artigos = $value;
    }
    /**
     * get fotos
     *
     */
    public function getFotos() {
    	return $this->fotos;
    }
    
    /**
     * set fotos
     * @param Type $value
     *
     */
    public function setFotos($value) {
    	$this->fotos = $value;
    }
    /**
     * get produtos
     *
     */
    public function getProdutos() {
    	return $this->produtos;
    }
    
    /**
     * set produtos
     * @param Type $value
     *
     */
    public function setProdutos($value) {
    	$this->produtos = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("galeriaid", "galeriaid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("nome", "nome", "int", 11, array('formatter' => array('Galeria', 'gNome')));
        $this->_addField("descricao", "descricao", "int", 11, array('formatter' => array('Galeria', 'gDescricao')));
        $this->_addField("ordem", "ordem", "int", 11, array());
        $this->_addField("fotoq", "fotoq", "varchar", 250, array('notnull' => true));
        $this->_addField("foto", "foto", "varchar", 250, array('notnull' => true));
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Galeria', 'gHabilitadoSimNao')));

        
        $this->_addForeignRelation("artigos", self::ONE_TO_MANY, "Artigo", "galeriaid", null, null, False);
        $this->_addForeignRelation("fotos", self::ONE_TO_MANY, "Foto", "galeriaid", null, null, False);
        $this->_addForeignRelation("produtos", self::ONE_TO_MANY, "Produto", "galeriaid", null, null, False);
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Galeria
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Galeria;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
        public $lang;
        
    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    }
    
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    }
    
    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }


}
