<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "parceria"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Parceria extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'parceria';
    protected $_package   = 'Domain';
    
    
    public $parceriaid;
    public $nome;
    public $site;
    public $email;
    public $descricao;
    public $fotoq;
    public $foto;
    public $ordem;
    public $habilitado;
    public $parcatlink = array();
    
    
    /**
     * get parceriaid
     *
     */
    public function getParceriaid() {
    	return $this->parceriaid;
    }
    
    /**
     * set parceriaid
     * @param Type $value
     *
     */
    public function setParceriaid($value) {
    	$this->parceriaid = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get site
     *
     */
    public function getSite() {
    	return $this->site;
    }
    
    /**
     * set site
     * @param Type $value
     *
     */
    public function setSite($value) {
    	$this->site = $value;
    }
    /**
     * get email
     *
     */
    public function getEmail() {
    	return $this->email;
    }
    
    /**
     * set email
     * @param Type $value
     *
     */
    public function setEmail($value) {
    	$this->email = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get fotoq
     *
     */
    public function getFotoq() {
    	return $this->fotoq;
    }
    
    /**
     * set fotoq
     * @param Type $value
     *
     */
    public function setFotoq($value) {
    	$this->fotoq = $value;
    }
    /**
     * get foto
     *
     */
    public function getFoto() {
    	return $this->foto;
    }
    
    /**
     * set foto
     * @param Type $value
     *
     */
    public function setFoto($value) {
    	$this->foto = $value;
    }
    /**
     * get ordem
     *
     */
    public function getOrdem() {
    	return $this->ordem;
    }
    
    /**
     * set ordem
     * @param Type $value
     *
     */
    public function setOrdem($value) {
    	$this->ordem = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    /**
     * get parcatlink
     *
     */
    public function getParcatlink() {
    	return $this->parcatlink;
    }
    
    /**
     * set parcatlink
     * @param Type $value
     *
     */
    public function setParcatlink($value) {
    	$this->parcatlink = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("parceriaid", "parceriaid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true, 'formatter' => array('Parceria', 'gNome')));
        $this->_addField("site", "site", "varchar", 300, array());
        $this->_addField("email", "email", "varchar", 300, array());
        $this->_addField("descricao", "descricao", "int", 11, array('formatter' => array('Parceria', 'gDescricao')));
        $this->_addField("fotoq", "fotoq", "varchar", 250, array());
        $this->_addField("foto", "foto", "varchar", 250, array());
        $this->_addField("ordem", "ordem", "int", 11, array());
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Parceria', 'gHabilitadoSimNao')));

        
        $this->_addForeignRelation("parcatlink", self::ONE_TO_MANY, "Parcatlink", "parceriaid", null, null, null);
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Parceria
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Parceria;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
        public $lang;
        
    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    }
    
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    }
    
    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }


}
