<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "tipomedia"
 * in 2013-08-29
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Tipomedia extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'tipomedia';
    protected $_package   = 'Domain';
    
    
    public $tipomediaid;
    public $nome;
    public $medias = array();
    
    
    /**
     * get tipomediaid
     *
     */
    public function getTipomediaid() {
    	return $this->tipomediaid;
    }
    
    /**
     * set tipomediaid
     * @param Type $value
     *
     */
    public function setTipomediaid($value) {
    	$this->tipomediaid = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get medias
     *
     */
    public function getMedias() {
    	return $this->medias;
    }
    
    /**
     * set medias
     * @param Type $value
     *
     */
    public function setMedias($value) {
    	$this->medias = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("tipomediaid", "tipomediaid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true,'formatter' => array('Tipomedia', 'gNome')));

        
        $this->_addForeignRelation("medias", self::ONE_TO_MANY, "Media", "tipomediaid", null, null, False);
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Tipomedia
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Tipomedia;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE

        public $lang;
        
    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    } 

}
