<?php
require_once realpath(dirname(__FILE__)) . '/../../Control/ControlDB.php';
require_once realpath(dirname(__FILE__)) . '/../../Util/Utilidades.php';
require_once realpath(dirname(__FILE__)) . '/../../Util/formAjax/FormAjax.php';

class Idiomas {
	public static function getTexto($id, $lang = '')
	{
            	if ($id == '')
		{
			return '';
		}
		$idioma = new Idioma();
		if ($lang == '')
		{
			if (isset ($_SESSION['lang']))
                        {
                                $lang = $_SESSION['lang'];
                        } else {
                            $lang = 'pt';
                        }
		}
		$idioma->id = $id;
		$idioma->lang = $lang;
		$idioma->find(true);
		if ($idioma->count() == 0)
		{
			//Caso não encontre no idioma desejado peque o português
			$idioma->id = $id;
			$idioma->lang = 'pt';
			$idioma->find(true);
		}
		return $idioma->getTexto();
	}

	public static function setTexto($id, $lang, $texto)
	{
                $lang = substr($lang, 0, 2);
            	$idioma = new Idioma();
		if ($id == '')
		{
			$id = Utilidades::getGeneretor('id');
		}
		if ($lang == '')
		{	
			$lang = $_SESSION['lang'];
		}
		$idioma->setId($id);
		$idioma->setLang($lang);
		$idioma->find(true);
		if ($idioma->count() == 0)
		{
			$idioma = new Idioma();		
		}
		$idioma->setId($id);
		$idioma->setLang($lang);
		$idioma->setTexto($texto);
		$idioma->save();
		return $id;
	}
	
	public static function getFormatoData($lang)
	{
		if ($lang == '')
		{
			if (isset($_SESSION['lang']))
			{
				$lang = $_SESSION['lang'];
			} else {
				$lang = 'pt';
			}
		}
	$opIdioma = new OpIdiomas();
	$opIdioma->setLang($lang);
	$opIdioma->find(True);
	return $opIdioma->getFormatodata();
	}
	
	public static function deleteIdioma(Idioma $idioma)
	{
		$idioma->delete();
	}
	
	public static function deleteTexto($id)
	{
		$idioma = new Idioma();
		$idioma->setId($id);
		$idioma->find(false);
		while ($idioma->fetch())
		{
			$idioma->delete();				
		}
	}
        
        public static function ComboSelecionarIdiomaPainelControle($acao, $pk, $lang, $funcao='mostrarFormAtualizar')
        {   
            $saida = '';
            if ($pk != '')
            {
                $saida = '<section><label for="comboIdioma">Selecionar Idioma</label>';
                $saida.= '<div>' . FormAjax::criarSeletorIdioma($acao, $pk, $lang, $funcao) . '</div>';
                $saida.= '</section>';
            }
            return $saida;
        }
}
	
?>