<?php
/**
 * Classe de Eventos, usada no fluxo de eventos/ouvintes
 * @author Hugo Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Lumine
 */

/**
 * Classe de Eventos, usada no fluxo de eventos/ouvintes
 * @author Hugo Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Lumine
 */
class Lumine_Event {
	
	
	/**
	 * Disparado antes de efetuar um Select
	 * @var string
	 */
	const PRE_SELECT = 'preSelect';
	/**
	 * Disparado apos efetuar um Select
	 * @var string
	 */
	const POS_SELECT = 'posSelect';
	/**
	 * Disparado antes de inserir varios elementos
	 * @var string
	 */
	const PRE_MULTI_INSERT = 'onPreMultiInsert';
	/**
	 * Disparado apos inserir varios elementos
	 * @var string
	 */
	const POS_MULTI_INSERT = 'onPosMultiInsert';
	/**
	 * Disparado antes de recuperar um objeto
	 * @var string
	 */
	const PRE_GET = 'preGet';
	/**
	 * Disparado apos recuperar um objeto
	 * @var string
	 */
	const POS_GET = 'posGet';
	/**
	 * Disparado antes de inserir um objeto
	 * @var string
	 */
	const PRE_INSERT = 'preInsert';
	/**
	 * Disparado apos inserir um objeto
	 * @var string
	 */
	const POS_INSERT = 'posInsert';
	/**
	 * Disparado antes de atualizar um objeto
	 * @var string
	 */
	const PRE_UPDATE= 'preUpdate';
	/**
	 * Disparado apos atualizar um objeto
	 * @var string
	 */
	const POS_UPDATE = 'posUpdate';
	/**
	 * Disparado antes de salvar um objeto
	 * @var string
	 */
	const PRE_SAVE = 'preSave';
	/**
	 * Disparado apos salvar um objeto
	 * @var string
	 */
	const POS_SAVE = 'posSave';
	/**
	 * Disparado antes de deletar um objeto
	 * @var string
	 */
	const PRE_DELETE = 'preDelete';
	/**
	 * Disparado apos deletar um objeto
	 * @var string
	 */
	const POS_DELETE = 'posDelete';
	/**
	 * Disparado antes de executar uma query literal
	 * @var string
	 */
	const PRE_QUERY = 'preQuery';
	/**
	 * Disparado apos executar uma query literal
	 * @var string
	 */
	const POS_QUERY = 'posQuery';
	/**
	 * Disparado antes de efetuar uma consulta com find
	 * @var string
	 */
	const PRE_FIND = 'preFind';
	/**
	 * Disparado apos efetuar uma consulta com find
	 * @var string
	 */
	const POS_FIND = 'posFind';
	/**
	 * Disparado antes de formatar o valor de um campo
	 * @var string
	 */
	const PRE_FORMAT = 'preFormat';
	/**
	 * Disparado apos formatar o valor de um campo
	 * @var string
	 */
	const POS_FORMAT = 'posFormat';
	/**
	 * Disparado antes de executar uma consulta
	 * @var string
	 */
	const PRE_EXECUTE = 'preExecute';
	/**
	 * Disparado apos executar uma consulta
	 * @var string
	 */
	const POS_EXECUTE = 'posExecute';
	/**
	 * Disparado quando criar um novo objeto
	 * @var string
	 */
	const CREATE_OBJECT = 'onCreateObject';
	/**
	 * Disparado quando houver erro de execucao de SQL
	 * @var string
	 */
	const EXECUTE_ERROR = 'onExecuteError';
	/**
	 * Disparado quando houver erro na conexao
	 * @var string
	 */
	const CONNECTION_ERROR = 'onConnectionError';
	/**
	 * Disparado antes da conexao ser efetuada
	 * @var string
	 */
	const PRE_CONNECT = 'preConnect';
	/**
	 * Disparado apos a conexao ser efetuada
	 * @var string
	 */
	const POS_CONNECT = 'posConnect';
	/**
	 * Disparado antes do fechamento da conexao
	 * @var string
	 */
	const PRE_CLOSE = 'preClose';
	/**
	 * Disparado apos o fechamento da conexao
	 * @var string
	 */
	const POS_CLOSE = 'posClose';
	
	/**
	 * Tipo de evento disparado
	 * @var string
	 */
	public $type;
	
	/**
	 * Construtor
	 * 
	 * @author Hugo Ferreira da Silva
	 * @link http://www.hufersil.com.br/lumine
	 * @param $type
	 * @return Lumine_Event
	 */
	function __construct($type){
		$this->type = $type;
	}
	
}

