<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "artigo"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Artigo extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'artigo';
    protected $_package   = 'Domain';
    
    
    public $artigoid;
    public $artigotipoid;
    public $bloqueado;
    public $fixo;
    public $titulo;
    public $dataartigo;
    public $ordem;
    public $descricao;
    public $texto;
    public $tags;
    public $fotoq;
    public $foto;
    public $galeriaid;
    public $habilitado;
    
    
    /**
     * get artigoid
     *
     */
    public function getArtigoid() {
    	return $this->artigoid;
    }
    
    /**
     * set artigoid
     * @param Type $value
     *
     */
    public function setArtigoid($value) {
    	$this->artigoid = $value;
    }
    /**
     * get artigotipoid
     *
     */
    public function getArtigotipoid() {
    	return $this->artigotipoid;
    }
    
    /**
     * set artigotipoid
     * @param Type $value
     *
     */
    public function setArtigotipoid($value) {
    	$this->artigotipoid = $value;
    }
    /**
     * get bloqueado
     *
     */
    public function getBloqueado() {
    	return $this->bloqueado;
    }
    
    /**
     * set bloqueado
     * @param Type $value
     *
     */
    public function setBloqueado($value) {
    	$this->bloqueado = $value;
    }
    /**
     * get fixo
     *
     */
    public function getFixo() {
    	return $this->fixo;
    }
    
    /**
     * set fixo
     * @param Type $value
     *
     */
    public function setFixo($value) {
    	$this->fixo = $value;
    }
    /**
     * get titulo
     *
     */
    public function getTitulo() {
    	return $this->titulo;
    }
    
    /**
     * set titulo
     * @param Type $value
     *
     */
    public function setTitulo($value) {
    	$this->titulo = $value;
    }
    /**
     * get dataartigo
     *
     */
    public function getDataartigo() {
    	return $this->dataartigo;
    }
    
    /**
     * set dataartigo
     * @param Type $value
     *
     */
    public function setDataartigo($value) {
    	$this->dataartigo = $value;
    }
    /**
     * get ordem
     *
     */
    public function getOrdem() {
    	return $this->ordem;
    }
    
    /**
     * set ordem
     * @param Type $value
     *
     */
    public function setOrdem($value) {
    	$this->ordem = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get texto
     *
     */
    public function getTexto() {
    	return $this->texto;
    }
    
    /**
     * set texto
     * @param Type $value
     *
     */
    public function setTexto($value) {
    	$this->texto = $value;
    }
    /**
     * get tags
     *
     */
    public function getTags() {
    	return $this->tags;
    }
    
    /**
     * set tags
     * @param Type $value
     *
     */
    public function setTags($value) {
    	$this->tags = $value;
    }
    /**
     * get fotoq
     *
     */
    public function getFotoq() {
    	return $this->fotoq;
    }
    
    /**
     * set fotoq
     * @param Type $value
     *
     */
    public function setFotoq($value) {
    	$this->fotoq = $value;
    }
    /**
     * get foto
     *
     */
    public function getFoto() {
    	return $this->foto;
    }
    
    /**
     * set foto
     * @param Type $value
     *
     */
    public function setFoto($value) {
    	$this->foto = $value;
    }
    /**
     * get galeriaid
     *
     */
    public function getGaleriaid() {
    	return $this->galeriaid;
    }
    
    /**
     * set galeriaid
     * @param Type $value
     *
     */
    public function setGaleriaid($value) {
    	$this->galeriaid = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("artigoid", "artigoid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("artigotipoid", "artigotipoid", "int", 11, array('foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'artigotipoid', 'class' => 'Artigotipo'));
        $this->_addField("bloqueado", "bloqueado", "int", 11, array('formatter' => array('Artigo', 'gBloqueadoSimNao')));
        $this->_addField("fixo", "fixo", "int", 11, array('formatter' => array('Artigo', 'gFixoSimNao')));
        $this->_addField("titulo", "titulo", "int", 11, array('notnull' => true, 'formatter' => array('Artigo', 'gTitulo')));
        $this->_addField("dataartigo", "dataartigo", "date", null, array('formatter' => array('Artigo', 'gDataArtigo')));
        $this->_addField("ordem", "ordem", "int", 11, array());
        $this->_addField("descricao", "descricao", "int", 11, array('formatter' => array('Artigo', 'gDescricao')));
        $this->_addField("texto", "texto", "int", 11, array('notnull' => true, 'formatter' => array('Artigo', 'gTexto')));
        $this->_addField("tags", "tags", "int", 11, array('formatter' => array('Artigo', 'gTags')));
        $this->_addField("fotoq", "fotoq", "varchar", 250, array());
        $this->_addField("foto", "foto", "varchar", 250, array());
        $this->_addField("galeriaid", "galeriaid", "int", 11, array('foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'galeriaid', 'class' => 'Galeria'));
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Artigo', 'gHabilitadoSimNao')));
        
        //$this->addFormatter('texto', 'gTexto');

        
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Artigo
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Artigo;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE

        public $lang;
        
    public function gTitulo() {
        return Idiomas::getTexto($this->titulo, $this->lang);
    }
    
    public function sTitulo($value) {
        $this->titulo = Idiomas::setTexto($this->titulo, $this->lang, $value);
    }
    
    public function gTexto() {
        return Idiomas::getTexto($this->texto, $this->lang);
    }

    public function sTexto($value) {
        $this->texto = Idiomas::setTexto($this->texto, $this->lang, $value);
    }
    
    public function gDataArtigo() {
        return Utilidades::converterData($this->dataartigo, 'aaaa-mm-dd', Idiomas::getFormatoData('pt'));
    }

    public function sDataArtigo($value) {
        $this->dataartigo = Utilidades::converterData($value, Idiomas::getFormatoData('pt'), 'aaaa-mm-dd');
        ;
    }
    
    public function gTags() {
        return Idiomas::getTexto($this->tags, $this->lang);
    }

    public function sTags($value) {
        $this->tags = Idiomas::setTexto($this->tags, $this->lang, $value);
    }
    
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    }

    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }
    
    public function gBloqueadoSimNao() {
        if ($this->bloqueado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }
    
    public function gFixoSimNao() {
        if ($this->fixo == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }

}
