<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "media"
 * in 2013-08-29
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Media extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'media';
    protected $_package   = 'Domain';
    
    
    public $mediaid;
    public $galmedia;
    public $nome;
    public $descricao;
    public $tipomediaid;
    public $valor;
    public $habilitado;
    
    
    /**
     * get mediaid
     *
     */
    public function getMediaid() {
    	return $this->mediaid;
    }
    
    /**
     * set mediaid
     * @param Type $value
     *
     */
    public function setMediaid($value) {
    	$this->mediaid = $value;
    }
    /**
     * get galmedia
     *
     */
    public function getGalmedia() {
    	return $this->galmedia;
    }
    
    /**
     * set galmedia
     * @param Type $value
     *
     */
    public function setGalmedia($value) {
    	$this->galmedia = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get tipomediaid
     *
     */
    public function getTipomediaid() {
    	return $this->tipomediaid;
    }
    
    /**
     * set tipomediaid
     * @param Type $value
     *
     */
    public function setTipomediaid($value) {
    	$this->tipomediaid = $value;
    }
    /**
     * get valor
     *
     */
    public function getValor() {
    	return $this->valor;
    }
    
    /**
     * set valor
     * @param Type $value
     *
     */
    public function setValor($value) {
    	$this->valor = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("mediaid", "mediaid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("galmedia", "galmedia", "int", 11, array('notnull' => true, 'foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'galmediaid', 'class' => 'Galmedia'));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true, 'formatter' => array('Media', 'gNome')));
        $this->_addField("descricao", "descricao", "int", 11, array('formatter' => array('Media', 'gDescricao')));
        $this->_addField("tipomediaid", "tipomediaid", "int", 11, array('foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'tipomediaid', 'class' => 'Tipomedia'));
        $this->_addField("valor", "valor", "varchar", 1000, array('notnull' => true));
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Media', 'gHabilitadoSimNao')));

        
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Media
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Media;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE

    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    }
    
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    }
    
    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }

}
