<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "parceriaCategoria"
 * in 2013-05-16
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Parceriacategoria extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'parceriaCategoria';
    protected $_package   = 'Domain';
    
    
    public $parceriacategoriaid;
    public $idsite;
    public $nome;
    public $descricao;
    public $descricaocurta;
    public $habilitado;
    public $tag;
    public $ordem;
    public $parcatlink = array();
    
    
    /**
     * get parceriacategoriaid
     *
     */
    public function getParceriacategoriaid() {
    	return $this->parceriacategoriaid;
    }
    
    /**
     * set parceriacategoriaid
     * @param Type $value
     *
     */
    public function setParceriacategoriaid($value) {
    	$this->parceriacategoriaid = $value;
    }
    /**
     * get idsite
     *
     */
    public function getIdsite() {
    	return $this->idsite;
    }
    
    /**
     * set idsite
     * @param Type $value
     *
     */
    public function setIdsite($value) {
    	$this->idsite = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get descricaocurta
     *
     */
    public function getDescricaocurta() {
    	return $this->descricaocurta;
    }
    
    /**
     * set descricaocurta
     * @param Type $value
     *
     */
    public function setDescricaocurta($value) {
    	$this->descricaocurta = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    /**
     * get tag
     *
     */
    public function getTag() {
    	return $this->tag;
    }
    
    /**
     * set tag
     * @param Type $value
     *
     */
    public function setTag($value) {
    	$this->tag = $value;
    }
    /**
     * get ordem
     *
     */
    public function getOrdem() {
    	return $this->ordem;
    }
    
    /**
     * set ordem
     * @param Type $value
     *
     */
    public function setOrdem($value) {
    	$this->ordem = $value;
    }
    /**
     * get parcatlink
     *
     */
    public function getParcatlink() {
    	return $this->parcatlink;
    }
    
    /**
     * set parcatlink
     * @param Type $value
     *
     */
    public function setParcatlink($value) {
    	$this->parcatlink = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("parceriacategoriaid", "parceriacategoriaid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("idsite", "idsite", "varchar", 250, array('notnull' => true));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true,'formatter' => array('parceriaCategoria', 'gNome')));
        $this->_addField("descricao", "descricao", "int", 11, array('formatter' => array('parceriaCategoria', 'gDescricao')));
        $this->_addField("descricaocurta", "descricaoCurta", "int", 11, array('formatter' => array('parceriaCategoria', 'gDescricaoCurta')));
        $this->_addField("habilitado", "habilitado", "int", 11, array());
        $this->_addField("tag", "tag", "int", 11, array('formatter' => array('parceriaCategoria', 'gTag')));
        $this->_addField("ordem", "ordem", "int", 11, array());

        
        $this->_addForeignRelation("parcatlink", self::ONE_TO_MANY, "Parcatlink", "parceriacategoriaid", null, null, null);
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Parceriacategoria
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Parceriacategoria;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
        public $lang;

    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    }
    
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    }

    public function gDescricaoCurta() {
        return Idiomas::getTexto($this->descricaocurta, $this->lang);
    }

    public function sDescricaoCurta($value) {
        $this->descricaocurta = Idiomas::setTexto($this->descricaocurta, $this->lang, $value);
    }
    
    public function gtag() {
        return Idiomas::getTexto($this->tag, $this->lang);
    }

    public function sTag($value) {
        $this->tag = Idiomas::setTexto($this->tag, $this->lang, $value);
    }    
}
