<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "produto"
 * in 2013-08-29
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Produto extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'produto';
    protected $_package   = 'Domain';
    
    
    public $produtoid;
    public $idsite;
    public $nome;
    public $descricao;
    public $foto;
    public $fotoq;
    public $habilitado;
    public $tag;
    public $categoriaid;
    public $nomecurto;
    public $galeriaid;
    public $galmediaid;
    public $preco;
    public $produtocategorias = array();
    public $produtodescricoes = array();
    
    
    /**
     * get produtoid
     *
     */
    public function getProdutoid() {
    	return $this->produtoid;
    }
    
    /**
     * set produtoid
     * @param Type $value
     *
     */
    public function setProdutoid($value) {
    	$this->produtoid = $value;
    }
    /**
     * get idsite
     *
     */
    public function getIdsite() {
    	return $this->idsite;
    }
    
    /**
     * set idsite
     * @param Type $value
     *
     */
    public function setIdsite($value) {
    	$this->idsite = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get descricao
     *
     */
    public function getDescricao() {
    	return $this->descricao;
    }
    
    /**
     * set descricao
     * @param Type $value
     *
     */
    public function setDescricao($value) {
    	$this->descricao = $value;
    }
    /**
     * get foto
     *
     */
    public function getFoto() {
    	return $this->foto;
    }
    
    /**
     * set foto
     * @param Type $value
     *
     */
    public function setFoto($value) {
    	$this->foto = $value;
    }
    /**
     * get fotoq
     *
     */
    public function getFotoq() {
    	return $this->fotoq;
    }
    
    /**
     * set fotoq
     * @param Type $value
     *
     */
    public function setFotoq($value) {
    	$this->fotoq = $value;
    }
    /**
     * get habilitado
     *
     */
    public function getHabilitado() {
    	return $this->habilitado;
    }
    
    /**
     * set habilitado
     * @param Type $value
     *
     */
    public function setHabilitado($value) {
    	$this->habilitado = $value;
    }
    /**
     * get tag
     *
     */
    public function getTag() {
    	return $this->tag;
    }
    
    /**
     * set tag
     * @param Type $value
     *
     */
    public function setTag($value) {
    	$this->tag = $value;
    }
    /**
     * get categoriaid
     *
     */
    public function getCategoriaid() {
    	return $this->categoriaid;
    }
    
    /**
     * set categoriaid
     * @param Type $value
     *
     */
    public function setCategoriaid($value) {
    	$this->categoriaid = $value;
    }
    /**
     * get nomecurto
     *
     */
    public function getNomecurto() {
    	return $this->nomecurto;
    }
    
    /**
     * set nomecurto
     * @param Type $value
     *
     */
    public function setNomecurto($value) {
    	$this->nomecurto = $value;
    }
    
    /**
     * get galeriaid
     *
     */
    public function getGaleriaid() {
    	return $this->galeriaid;
    }
    
    /**
     * set galeriaid
     * @param Type $value
     *
     */
    public function setGaleriaid($value) {
    	$this->galeriaid = $value;
    }
    /**
     * get galmediaid
     *
     */
    public function getGalmediaid() {
    	return $this->galmediaid;
    }
    
    /**
     * set galmediaid
     * @param Type $value
     *
     */
    public function setGalmediaid($value) {
    	$this->galmediaid = $value;
    }
    /**
     * get preco
     *
     */
    public function getPreco() {
    	return $this->preco;
    }
    
    /**
     * set preco
     * @param Type $value
     *
     */
    public function setpreco($value) {
    	$this->preco = $value;
    }
    /**
     * get produtocategorias
     *
     */
    public function getProdutocategorias() {
    	return $this->produtocategorias;
    }
    
    /**
     * set produtocategorias
     * @param Type $value
     *
     */
    public function setProdutocategorias($value) {
    	$this->produtocategorias = $value;
    }
    /**
     * get produtodescricoes
     *
     */
    public function getProdutodescricoes() {
    	return $this->produtodescricoes;
    }
    
    /**
     * set produtodescricoes
     * @param Type $value
     *
     */
    public function setProdutodescricoes($value) {
    	$this->produtodescricoes = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("produtoid", "produtoid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("idsite", "idsite", "varchar", 250, array('notnull' => true));
        $this->_addField("nome", "nome", "varchar", 250, array('notnull' => true));
        $this->_addField("descricao", "descricao", "int", 11, array('notnull' => true, 'formatter' => array('Produto', 'gDescricao')));
        $this->_addField("foto", "foto", "varchar", 250, array());
        $this->_addField("fotoq", "fotoq", "varchar", 250, array());
        $this->_addField("habilitado", "habilitado", "int", 11, array('formatter' => array('Produto', 'gHabilitadoSimNao')));
        $this->_addField("tag", "tag", "int", 11, array('formatter' => array('Produto', 'gTag')));
        $this->_addField("categoriaid", "categoriaid", "int", 11, array('foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'categoriaid', 'class' => 'Categoria'));
        $this->_addField("nomecurto", "nomecurto", "varchar", 50, array());
        $this->_addField("galeriaid", "galeriaid", "int", 11, array('foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'galeriaid', 'class' => 'Galeria'));
        $this->_addField("galmediaid", "galmediaid", "int", 11, array('foreign' => '1', 'onUpdate' => 'RESTRICT', 'onDelete' => 'RESTRICT', 'linkOn' => 'galmediaid', 'class' => 'Galmedia'));
        $this->_addField("preco", "preco", "decimal", 18, array('notnull' => true));

        
        $this->_addForeignRelation("produtocategorias", self::ONE_TO_MANY, "Produtocategoria", "produtoid", null, null, False);
        $this->_addForeignRelation("produtodescricoes", self::ONE_TO_MANY, "Produtodescricao", "produtoid", null, null, False);
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Produto
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Produto;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
    public $lang;
    
    public function gDescricao() {
        return Idiomas::getTexto($this->descricao, $this->lang);
    }

    public function sDescricao($value) {
        $this->descricao = Idiomas::setTexto($this->descricao, $this->lang, $value);
    }
    
    public function gTag() {
        return Idiomas::getTexto($this->tag, $this->lang);
    }

    public function sTag($value) {
        $this->tag = Idiomas::setTexto($this->tag, $this->lang, $value);
    }

    public function gHabilitadoSimNao() {
        if ($this->habilitado == 1) {
            return Idiomas::getTexto('sim');
        } else {
            return Idiomas::getTexto('não');
        }
    }
}
