<?php
#### START AUTOCODE
################################################################################
#  Lumine - Database Mapping for PHP
#  Copyright (C) 2005  Hugo Ferreira da Silva
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
################################################################################
/**
 * Classe generada para a tabela "produtodescricao"
 * in 2013-08-29
 * @author Hugo Ferreira da Silva
 * @link http://www.hufersil.com.br/lumine
 * @package Domain
 *
 */

class Produtodescricao extends Lumine_Base {

    // sobrecarga
    protected $_tablename = 'produtodescricao';
    protected $_package   = 'Domain';
    
    
    public $produtodescricaoid;
    public $produtoid;
    public $nome;
    public $valor;
    
    
    /**
     * get produtodescricaoid
     *
     */
    public function getProdutodescricaoid() {
    	return $this->produtodescricaoid;
    }
    
    /**
     * set produtodescricaoid
     * @param Type $value
     *
     */
    public function setProdutodescricaoid($value) {
    	$this->produtodescricaoid = $value;
    }
    /**
     * get produtoid
     *
     */
    public function getProdutoid() {
    	return $this->produtoid;
    }
    
    /**
     * set produtoid
     * @param Type $value
     *
     */
    public function setProdutoid($value) {
    	$this->produtoid = $value;
    }
    /**
     * get nome
     *
     */
    public function getNome() {
    	return $this->nome;
    }
    
    /**
     * set nome
     * @param Type $value
     *
     */
    public function setNome($value) {
    	$this->nome = $value;
    }
    /**
     * get valor
     *
     */
    public function getValor() {
    	return $this->valor;
    }
    
    /**
     * set valor
     * @param Type $value
     *
     */
    public function setValor($value) {
    	$this->valor = $value;
    }
    
    /**
     * Inicia os valores da classe
     * @author Hugo Ferreira da Silva
     * @return void
     */
    protected function _initialize()
    {
        
        
        # nome_do_membro, nome_da_coluna, tipo, comprimento, opcoes
        
        $this->_addField("produtodescricaoid", "produtodescricaoid", "int", 11, array('primary' => true, 'notnull' => true, 'autoincrement' => true));
        $this->_addField("produtoid", "produtoid", "int", 11, array('notnull' => true, 'foreign' => '1', 'onUpdate' => 'CASCADE', 'onDelete' => 'CASCADE', 'linkOn' => 'produtoid', 'class' => 'Produto'));
        $this->_addField("nome", "nome", "int", 11, array('notnull' => true, 'formatter' => array('Produtodescricao', 'gNome')));
        $this->_addField("valor", "valor", "int", 11, array('notnull' => true, 'formatter' => array('Produtodescricao', 'gValor')));

        
    }

    /**
     * Recupera um objeto estaticamente
     * @author Hugo Ferreira da Silva
     * @return Produtodescricao
     */
    public static function staticGet($pk, $pkValue = null)
    {
        $obj = new Produtodescricao;
        $obj->get($pk, $pkValue);
        return $obj;
    }

	/**
	 * chama o destrutor pai
	 *
	 */
	function __destruct()
	{
		parent::__destruct();
	}
	
    #------------------------------------------------------#
    # Coloque todos os metodos personalizados abaixo de    #
    # END AUTOCODE                                         #
    #------------------------------------------------------#
    #### END AUTOCODE
        
    public $lang;
    
    public function gNome() {
        return Idiomas::getTexto($this->nome, $this->lang);
    }

    public function sNome($value) {
        $this->nome = Idiomas::setTexto($this->nome, $this->lang, $value);
    }
    
    public function gValor() {
        return Idiomas::getTexto($this->valor, $this->lang);
    }

    public function sValor($value) {
        $this->valor = Idiomas::setTexto($this->valor, $this->lang, $value);
    }
            


}
