<?php
require_once 'Util/Utilidades.php';
class Imagem {
	
	//Tamanho do arquivo em bytes
	public $tamanho;
	// Largura máxima (pixels)
	public $largura;
	// Altura máxima (pixels)
	public $altura;
	// Largura para a Thumbs (pixels)
	public $largura_thumbs;
	
	public function __construct($tamanho = 307200, $largura = 900, $altura = 500, $largura_thumbs = 100)
	{
		$this->tamanho = $tamanho; //300 kb
		$this->largura = $largura;
		$this->altura = $altura;
		$this->largura_thumbs = $largura_thumbs;
	}
		
	function enviaArquivo($arquivo, $pastaDestino) 
	{
		$config["tamanho"] = $this->tamanho * 10;
		// Largura máxima (pixels)
		$config["largura"] = $this->largura * 10;
		// Altura máxima (pixels)
		$config["altura"]  = $this->altura * 10;
		//fazer verificações na imagem
		if(!eregi("^image\/(pjpeg|jpeg|png|gif|bmp)$", $arquivo["type"]))
		{
			$erro[] = "Arquivo em formato inválido! A imagem deve ser jpg, jpeg, bmp, gif ou png. Envie outro arquivo, seu arquivo é (" . $arquivo["type"] . ")" ;
		} else {
			// Verifica tamanho do arquivo
			if($arquivo["size"] >= $config["tamanho"])
			{
				$erro[] = "Arquivo em tamanho muito grande! A imagem deve ser de no máximo " . $config["tamanho"] . " bytes. 		Envie outro arquivo";
			}
        	// Para verificar as dimensões da imagem
			$tamanhos = $arquivo["size"];
            // Verifica largura
			if($tamanhos[0] > $config["largura"])
			{
				$erro[] = "Largura da imagem não deve ultrapassar " . $config["largura"] . " pixels";
			}
	        // Verifica altura
	        if($tamanhos[1] > $config["altura"])
			{
				$erro[] = "Altura da imagem não deve ultrapassar " . $config["altura"] . " pixels";
			}
		}
		// Imprime as mensagens de erro
		if(isset($erro))
		{
			$erros[] = 'Erro(s):';
			foreach($erro as $err)
			{
				$erros[] = $err;
				echo " - " . $err . "<BR>";
			}
	        echo "Não foi possivel enviar a imagem!";
	        return $erros;
	    }
		// Verificação de dados OK, nenhum erro ocorrido, executa então o upload...
		else
		{
			// Pega extensão do arquivo
			preg_match("/\.(gif|bmp|png|jpg|jpeg){1}$/i", $arquivo["name"], $ext);
		    // Gera um nome único para a imagem
			$imagem_nome = md5(uniqid(time())) . "." . $ext[1];
			// Caminho de onde a imagem ficará
			$imagem_dir = $pastaDestino . $imagem_nome;
			// Faz o upload da imagem
			copy($arquivo["tmp_name"], $imagem_dir);
			unlink($arquivo["tmp_name"]);
			//move_uploaded_file($arquivo["tmp_name"], $imagem_dir);
			return $imagem_dir;
		}
    }
    
    //Créditos da função vai para: "vandai" on www.akemapa.com.
    //Retirado em http://www.php.net/imagecreatefromjpeg
    //Adpatada por Luciano Donato
	function resize($img, $thumb_width, $newfilename, $pasta = 0, $height = 0, $qualidade = 100)
	{
		if ($pasta <> 0)
		{
			preg_match("/\.(gif|bmp|png|jpg|jpeg){1}$/i", $img, $ext);
		    // Gera um nome único para a imagem
			$imagem_nome = md5(uniqid(time())) . "." . $ext[1];
			$newfilename = $newfilename . $imagem_nome;
		}
  		$max_width=$thumb_width;
  		if ($height == 1)
  		{
  			$thumb_height = $thumb_width;
  		}

    	//Check if GD extension is loaded
    	if (!extension_loaded('gd') && !extension_loaded('gd2'))
    	{
        	trigger_error("GD is not loaded", E_USER_WARNING);
        	return false;
    	}

	    //Get Image size info
	    //removiado echo getimagesize($img);
    	list($width_orig, $height_orig, $image_type) = getimagesize($img);
   
   		switch ($image_type)
    	{
        	case 1: $im = imagecreatefromgif($img); break;
        	case 2: $im = imagecreatefromjpeg($img);  break;
        	case 3: $im = imagecreatefrompng($img); break;
        	default:  trigger_error('Unsupported filetype!', E_USER_WARNING);  break;
    	}
   
    	/*** calculate the aspect ratio ***/
    	$aspect_ratio = (float) $height_orig / $width_orig;

	    /*** calulate the thumbnail width based on the height ***/
    	if ($height == 0)
    	{
    		$thumb_height = round($thumb_width * $aspect_ratio);
    	} else {
    		$thumb_width = round($thumb_height * $aspect_ratio);
    	}
   
	    if ($height == 0)
	    { 
    		while($thumb_height>$max_width)
    		{
	        	$thumb_width-=10;
        		$thumb_height = round($thumb_width * $aspect_ratio);
    		}
	    } else {
	    	while($thumb_width>$max_width)
    		{
	        	$thumb_height-=10;
        		$thumb_width = round($thumb_height * $aspect_ratio);
    		}
	    }
   
    	$newImg = imagecreatetruecolor($thumb_width, $thumb_height);
   
	    /* Check if this image is PNG or GIF, then set if Transparent*/ 
    	/*if(($image_type == 1) OR ($image_type==3))
    	{
        	imagealphablending($newImg, false);
        	imagesavealpha($newImg,true);
        	$transparent = imagecolorallocatealpha($newImg, 255, 255, 255, 127);
        	imagefilledrectangle($newImg, 0, 0, $thumb_width, $thumb_height, $transparent);
    	}*/
    	imagecopyresampled($newImg, $im, 0, 0, 0, 0, $thumb_width, $thumb_height, $width_orig, $height_orig);
   
    	//Generate the file, and rename it to $newfilename
    	switch ($image_type)
    	{
        	case 1: imagegif($newImg,$newfilename); break;
        	case 2: imagejpeg($newImg,$newfilename,$qualidade);  break;
        	case 3: imagepng($newImg,$newfilename, $qualidade); break;
        	default:  trigger_error('Falha ao redimencionar imagem!', E_USER_WARNING);  break;
    	}
    	//if ($cortar == 0)
    	//{
    		return $newfilename;
    		
    	//} else {
    		
    		//return $crop->writeImage( $newfilename );
    	//}
}
    /*
     * Exemplo de upload de envio de foto
     * //Verifica se "UPO"
	 *if (isset($_FILES['txtFoto1']))
     *{
	 *  if ($_FILES['txtFoto1']['name'] <> '')
	 *  {
	 *  	$foto = $_FILES['txtFoto1'];
	 *  	$imagem = new Imagem(614400,900,500,160);
	 *	    $imagem->salvarOO($foto,$home->foto1Q, $home->foto1,'../fotos/home/','../fotos/home/thumbs/',1);
	 *  }
     *}
     */

	public function salvarOO ($foto,$pasta, $pasta_thumbs, $e_pasta_thumbs,$compactacao, $height) {
		$fotourl = $this->enviaArquivo($foto,$pasta);
		if ($fotourl[0] != 'Erro(s):')
		{
			//Utilidades::deletarAquivo($qualidade);
			//$qualidade = $fotourl;
			$qualidade = $this->resize($fotourl,$this->altura,$pasta,1,0,$compactacao);
			//echo 'Fim do Redimencionamento...<br/>';
			Utilidades::deletarAquivo($fotourl);
			//echo 'Gerada imagem com qualidade....<br/>';
			//Utilidades::deletarAquivo($thumb);
			$fotourlT = $this->resize($qualidade,$this->largura_thumbs,$pasta_thumbs,$e_pasta_thumbs,0,$compactacao);
			//echo 'Gerada thumb....<br/>';
			return array($qualidade, $fotourlT);
		}
	}
    
}

?>