<?php
require_once realpath(dirname(__FILE__)) .  '/../Control/ControlDB.php';
require_once realpath(dirname(__FILE__)) . '/Internacionalizacao/Idiomas.php';
class Utilidades {
	static function quotedStr($string)
	{
		return "'$string'";
	}
	
	/*static function getAutoIncremento($tabela) {
		$resultado = mysqli_query(ConnectionFactory::getConexao(), "SHOW TABLE STATUS LIKE " . Utilidades::quotedStr($tabela) );
		$registro = mysqli_fetch_array($resultado);
		return $registro['Auto_increment'];
		;
	}*/
	
	static public function converterData($data,$fent, $fsai)
	{
		if ($data <> '')
		{
			$ldia = strpos($fent,'d');
			$dia = substr($data,$ldia,2);
			$lmes = strpos($fent,'m');
			$mes = substr($data,$lmes,2);
			$lano = strpos($fent,'a');
			$ano = substr($data,$lano,4);
			//pegando posições de saida
			$ldia = strpos($fsai,'d');
			$lmes = strpos($fsai,'m');
			$lano = strpos($fsai,'a');
			$dataf = $fsai;
			$dataf = substr_replace($dataf, $dia,$ldia,2);
			$dataf = substr_replace($dataf, $mes,$lmes,2);
			$dataf = substr_replace($dataf, $ano,$lano,4);
			return $dataf;
		} else {
			return '';	
		}
	}
	
	static public function formatarNumero($valor,$decimal,$sepDecimalEnt,$sepDecimalSD){
		$l = strpos($valor, $sepDecimalEnt);
		if ($l != '')
		{
			$valor = substr_replace($valor,'.',$l,1);
		}
		$valor = number_format($valor, $decimal, '.', '');
		$l = strpos($valor, '.');
		return substr_replace($valor,$sepDecimalSD,$l,1);
	}
	
	static function deletarAquivo($file)
	{
		if (file_exists($file))
		{
			return unlink($file);
		} else {
			return true;
		}
	}
	
	static public function formatarNumeroAgrupamento($valor){
		return number_format($valor, 2, ',', '.');
	}
	
	/**
 * Função que abrevia uma string caso ela exceda o tamanho máximo permitido para o resumo
 * sem cortar palavras pela metade.
 *
 * @author Igor Escobar, blog [at] igorescobar [dot] com
 * @param string $texto parâmetro que guarda o texto completo que você quer resumir.
 * @param int $limite parâmetro que guarda o limite de caracteres permitido pelo resumo.
 * @param string $tres_p parâmetro que guarda a string que você quer usar para representar
 *                                que o texto foi resumido
 * @access public
 * @uses abreviaString("Texto, texto, texto", 10, "...");
 */
	static  function abreviaString($texto, $limite, $tres_p = '...')
	{
	$totalCaracteres = 0;
	//Retorna o texto em plain/text
	$texto = strip_tags($texto);
	//Cria um array com todas as palavras do texto
	$vetorPalavras = explode(" ",$texto);
	if(strlen($texto) <= $limite):
		$tres_p = "";
		$novoTexto = $texto;
	else:
		//Começa a criar o novo texto resumido.
		$novoTexto = "";
		//Acrescenta palavra por palavra na string enquanto ela
		//não exceder o tamanho máximo do resumo
		for($i = 0; $i < count($vetorPalavras); $i++):
			$totalCaracteres += strlen(" ".$vetorPalavras[$i]);
			if($totalCaracteres <= $limite)
			{
				$novoTexto .= ' ' . $vetorPalavras[$i];
			} else { 
				break;
			}
		endfor;
	endif;
	return $novoTexto . $tres_p;
}
	
//Pegar um Generator a atualizar
	public static function getGeneretor($campo){
		$var = null;
		$generator = new GeneratorAuto();
		$generator->get(1);
		$pgt = '$var = &$generator->'. $campo . ';';
		eval($pgt);
		$atual = $var;
		$novo = $atual + 1;
		$var = $novo;
		//eval($pgt);
		$generator->save();		
		return $atual;
	}
	
//Salvar um arquivo
	public static function enviarArquivo($arquivoup, $destino){
		$nome = $arquivoup["name"];
		$dest = $destino;
		// criar nome que nao repete
		$hora_no_servidor = time();
		$pasta = date("Y", ($hora_no_servidor)) . date("m", ($hora_no_servidor)) . date("d", ($hora_no_servidor)) . date("H", ($hora_no_servidor)) . date("i", ($hora_no_servidor)) . date("s", ($hora_no_servidor));  
		//fim de criação
		$destino = $destino . $pasta; 
		mkdir($destino, 0777);
		$destino .= '/' . $nome;
		$dest = $dest . $nome;
		copy($arquivoup["tmp_name"], $destino);
		unlink($arquivoup["tmp_name"]);
		//move_uploaded_file($arquivoup["tmp_name"], $dest); 
		return $destino;
	}	

	//colocar imagem com efeito
	public static function imagemComEfeito($fotoq, $foto, $grupo, $titulo, $align='default')
	{
		if ($foto <> null)
		{
			return '<a href="' . $fotoq . '" rel="shadowbox[' . $grupo . ']" title="' . $titulo . '"><img align="' . $align .'" src="' . $foto . '" alt="' . $titulo . '" title="' . $titulo . '" class="bordaAmarela"/></a>';
			//return '<a href="' . $fotoq . '" class="efeito" rel="lightbox[' . $grupo . ']" title="' . $titulo . '"><img align="' . $align .'" src="' . $foto . '" alt="' . $titulo . '" title="' . $titulo . '" class="bordaAmarela"/></a>';
			//return '<a href="' . $fotoq . '" rel="lightbox[' . $grupo . ']" title="' . $titulo . '"><img align="' . $align .'" src="' . $foto . '" alt="' . $titulo . '" title="' . $titulo . '"/></a>';
		} else {
			return '';
		}
	}
	
	public static function voltar($texto = 'padrão')
	{
		if ($texto == 'padrão')
		{
			$texto = Idiomas::getTexto('voltar');
		}
		echo '<a href="javascript:window.history.go(-1)">' . $texto .'</a>';
	}
	
	public static function formSeletorBoleano($name, $padrao = 1, $id = '') {
		if ($id == '')
		{
			$id = $name;
		}
		//echo '<select name="' . $name . '" id="' . $id . '">';
		if ($padrao == 1)
		{
			echo '<option value="1" selected="selected">' . Idiomas::getTexto('sim') . '</option>';
		} else
		{
			echo '<option value="1">'. Idiomas::getTexto('sim') . '</option>';
		}
	if ($padrao == 0)
		{
			echo '<option value="0" selected="selected">' . Idiomas::getTexto('não') . '</option>';
		} else
		{
			echo '<option value="0">'. Idiomas::getTexto('não') . '</option>';
		}
		//echo '</select>';
	}
	
	public static function formselectorOpcaoMarcada($valor, $texto, $padrao = 'null'){
			if ($valor == $padrao)
			{ 
				echo '<option value="' . $valor . '" selected="selected">' . $texto . '</option>';
			} else
			{
				echo '<option value="' . $valor . '">' . $texto . '</option>';
			}
	}
	
	public static function CriarImg($url,$titulo, $width, $height, $align = 'Default', $classe="noclass"){
		if ($width != 0)
		{
			echo '<img class="' . $classe . '" src="' . $url . '" width="' . $width . '" height="' . $height . '" alt="' . $titulo . '" title="' . $titulo . '" />';
		}
		else
		{
			echo '<img class="' . $classe . '" src="' . $url . '" alt="' . $titulo . '" title="' . $titulo . '" />';
		}
	}
	
	public static function gerarTamanho($tamanhoORI, $largura, $altura=0){
		if ($largura != 0)
		{
			$tamanhoNovo[] = $largura;
			$prop = $tamanhoORI[0] / $largura;
			$tamanhoNovo[] = round($tamanhoORI[1] / $prop);
			 return $tamanhoNovo;
		}
	}

        //Coletado em http://roshanbh.com.np/2007/12/getting-real-ip-address-in-php.html
        public static function pegarIPReal()
        {
            if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
            {
                $ip=$_SERVER['HTTP_CLIENT_IP'];
            }
            elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
            {
                $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
            }
            else
            {
                $ip=$_SERVER['REMOTE_ADDR'];
            }
            return $ip;
        }

        public static function adicionarBotaoPagSeguro($codigo, $valor, $titulo, $email)
        {
            $valorconv = number_format($valor,2,'','');
            $ret = '<!-- INICIO FORMULARIO BOTAO PAGSEGURO -->';
            $ret.= '<form target="pagseguro" action="https://pagseguro.uol.com.br/checkout/checkout.jhtml" method="post">';
            $ret.= '<input type="hidden" name="email_cobranca" value="' . $email . '" />';
            $ret.= '<input type="hidden" name="tipo" value="CP" />';
            $ret.= '<input type="hidden" name="moeda" value="BRL" />';
            $ret.= '<input type="hidden" name="item_id_1" value="' . $codigo . '" />';
            $ret.= '<input type="hidden" name="item_descr_1" value="' . $titulo . '" />';
            $ret.= '<input type="hidden" name="item_quant_1" value="1" />';
            $ret.= '<input type="hidden" name="item_valor_1" value="' . $valorconv . '" />';
            $ret.= '<input type="hidden" name="item_frete_1" value="000" />';
            $ret.= '<input type="hidden" name="encoding" value="UTF-8" />';
            $ret.= '<input type="image" src="https://p.simg.uol.com.br/out/pagseguro/i/botoes/pagamento/btnPagarBR.jpg" name="submit" alt="Pague com PagSeguro - é rápido, grátis e seguro!" />';
            $ret.= '</form>';
            $ret.= '<!-- FINAL FORMULARIO BOTAO PAGSEGURO -->';
            return $ret;
        }

        public static function adicionarBotaoPagSegurocomCliente($codigo, $valor, $titulo, $email, $clienteNome, $clienteCEP, $clienteEndereco, $clienteNumero, $clienteComplemento, $clienteBairro, $clienteCidade, $clienteUF, $clienteDDD, $clienteTelefone, $clienteEmail)
        {
            $valorconv = number_format($valor,2,'','');
            $ret = '<!-- INICIO FORMULARIO BOTAO PAGSEGURO -->';
            $ret.= '<form target="pagseguro" action="https://pagseguro.uol.com.br/checkout/checkout.jhtml" method="post">';
            $ret.= '<input type="hidden" name="email_cobranca" value="' . $email . '" />';
            $ret.= '<input type="hidden" name="tipo" value="CP" />';
            $ret.= '<input type="hidden" name="moeda" value="BRL" />';
            $ret.= '<input type="hidden" name="item_id_1" value="' . $codigo . '" />';
            $ret.= '<input type="hidden" name="item_descr_1" value="' . $titulo . '" />';
            $ret.= '<input type="hidden" name="item_quant_1" value="1" />';
            $ret.= '<input type="hidden" name="item_valor_1" value="' . $valorconv . '" />';
            $ret.= '<input type="hidden" name="item_frete_1" value="000" />';
            $ret.= '<!-- INÍCIO DOS DADOS DO USUÁRIO -->';
            $ret.=  '<input type="hidden" name="cliente_nome" value="' . $clienteNome . '">';
            $ret.=  '<input type="hidden" name="cliente_cep" value="' . $clienteCEP . '">';
            $ret.=  '<input type="hidden" name="cliente_end" value="' . $clienteEndereco . '">';
            $ret.=  '<input type="hidden" name="cliente_num" value="' . $clienteNumero . '">';
            $ret.=  '<input type="hidden" name="cliente_compl" value="' . $clienteComplemento . '">';
            $ret.=  '<input type="hidden" name="cliente_bairro" value="' . $clienteBairro . '">';
            $ret.=  '<input type="hidden" name="cliente_cidade" value="' . $clienteCidade . '">';
            $ret.=  '<input type="hidden" name="cliente_uf" value="' . $clienteUF . '">';
            $ret.=  '<input type="hidden" name="cliente_pais" value="BRA">';
            $ret.=  '<input type="hidden" name="cliente_ddd" value="' . $clienteDDD . '">';
            $ret.=  '<input type="hidden" name="cliente_tel" value="' . $clienteTelefone . '">';
            $ret.=  '<input type="hidden" name="cliente_email" value="' . $clienteEmail . '">';
            $ret.=  '<!-- FIM DOS DADOS DO USUÁRIO -->';
            $ret.= '<input type="hidden" name="encoding" value="UTF-8" />';
            $ret.= '<input type="image" src="https://p.simg.uol.com.br/out/pagseguro/i/botoes/pagamento/btnPagueComBR.jpg" name="submit" alt="Pague com PagSeguro - é rápido, grátis e seguro!" />';
            $ret.= '</form>';
            $ret.= '<!-- FINAL FORMULARIO BOTAO PAGSEGURO -->';
            return $ret;
        }
        
        public static function OrdenarArray ($ar, $campo,$ordem = 0){
            if ((is_array($ar)) and (!empty($ar)))
            {
                foreach ($ar as $key => $row) {
                    $filtro[$key]  = $row[$campo];
                }
                if ($ordem == 0)
                {
                    array_multisort($filtro, SORT_ASC, $ar);
                } else  {
                    array_multisort($filtro, SORT_DESC, $ar);
                }
            }
            return $ar;
        }
}

?>