<?php
require_once(realpath(dirname(__FILE__)) . '/../Domain/FotoGrupo.php');

class Acomodacao {
	public $acomodacaoID;
	public $nome;
	public $descricao;
	public $foto;
	public $fotoQ;
	public $ordem;
	public $lang;
	/**
	 * @AssociationType Domain.FotoGrupo
	 * @AssociationMultiplicity 0..1
	 */
	public $fotoGrupo;
	public $fotoGrupoID;
	
	public function getAcomodacaoID() {
		return $this->acomodacaoID;
	}

	public function setAcomodacaoID($acomodacaoID) {
		$this->acomodacaoID = $acomodacaoID;
	}
	
	public function getDescricao() {
		return Idiomas::getTexto($this->descricao,$this->lang);
	}
	
	public function setDescricao($descricao) {
		$this->descricao = Idiomas::setTexto($this->descricao,$this->lang,$descricao);
	}
	
	public function getFoto() {
		return $this->foto;
	}
	
	public function setFoto($foto) {
		$this->foto = $foto;
	}
	
	public function getFotoGrupo() {
		return $this->fotoGrupo;
	}
	
	public function setFotoGrupo($fotoGrupo) {
		$this->fotoGrupo = $fotoGrupo;
	}
	
	public function getFotoGrupoID() {
		return $this->fotoGrupoID;
	}
	
	public function setFotoGrupoID($fotoGrupoID) {
		$this->fotoGrupoID = $fotoGrupoID;
	}
	
	public function getFotoQ() {
		return $this->fotoQ;
	}
	
	public function setFotoQ($fotoQ) {
		$this->fotoQ = $fotoQ;
	}
	
	public function getNome() {
		return Idiomas::getTexto($this->nome,$this->lang);
	}
	
	public function setNome($nome) {
		$this->nome = Idiomas::setTexto($this->nome,$this->lang,$nome);
	}
	/**
	 * @return unknown
	 */
	public function getOrdem() {
		return $this->ordem;
	}
	
	/**
	 * @param unknown_type $ordem
	 */
	public function setOrdem($ordem) {
		$this->ordem = $ordem;
	}


}
?>