<?php
require_once(realpath(dirname(__FILE__)) . '/../Domain/FotoGrupo.php');
require_once(realpath(dirname(__FILE__)) . '/../Domain/ArtigoClasse.php');

class Artigo {
	public $artigoID;
	public $artigoClasseID;
	public $nome;
	public $data;
	public $texto;
	public $foto;
	public $fotoQ;
	public $lang;
	/**
	 * @AssociationType Domain.FotoGrupo
	 * @AssociationMultiplicity 0..1
	 */
	public $fotoGrupo;
	public $fotoGrupoID;
	/**
	 * @AssociationType Domain.ArtigoClasse
	 * @AssociationMultiplicity 1
	 */
	public $artigoClasse;
	
	/**
	 * @return unknown
	 */
	public function getArtigoClasse() {
		return $this->artigoClasse;
	}
	
	/**
	 * @return unknown
	 */
	public function getArtigoClasseID() {
		return $this->artigoClasseID;
	}
	
	/**
	 * @return unknown
	 */
	public function getData() {
		return Utilidades::converterData($this->data,'aaaa-mm-dd',Idiomas::getFormatoData($this->lang));
	}
	
	/**
	 * @return unknown
	 */
	public function getArtigoID() {
		return $this->artigoID;
	}
	
	/**
	 * @return unknown
	 */
	public function getFoto() {
		return $this->foto;
	}
	
	/**
	 * @return unknown
	 */
	public function getFotoGrupo() {
		return $this->fotoGrupo;
	}
	
	/**
	 * @return unknown
	 */
	public function getFotoGrupoID() {
		return $this->fotoGrupoID;
	}
	
	/**
	 * @return unknown
	 */
	public function getFotoQ() {
		return $this->fotoQ;
	}
	
	/**
	 * @return unknown
	 */
	public function getNome() {
		return Idiomas::getTexto($this->nome,$this->lang);
	}
	
	/**
	 * @return unknown
	 */
	public function getTexto() {
		return Idiomas::getTexto($this->texto,$this->lang);
	}
	
	/**
	 * @param unknown_type $artigoClasse
	 */
	public function setArtigoClasse($artigoClasse) {
		$this->artigoClasse = $artigoClasse;
	}
	
	/**
	 * @param unknown_type $artigoClasseID
	 */
	public function setArtigoClasseID($artigoClasseID) {
		$this->artigoClasseID = $artigoClasseID;
	}
	
	/**
	 * @param unknown_type $data
	 */
	public function setData($data) {
		$this->data = Utilidades::converterData($data,Idiomas::getFormatoData($this->lang),'aaaa-mm-dd');
	}
	
	/**
	 * @param unknown_type $eventoID
	 */
	public function setArtigoID($artigoID) {
		$this->artigoID = $artigoID;
	}
	
	/**
	 * @param unknown_type $foto
	 */
	public function setFoto($foto) {
		$this->foto = $foto;
	}
	
	/**
	 * @param unknown_type $fotoGrupo
	 */
	public function setFotoGrupo(FotoGrupo $fotoGrupo) {
		$this->fotoGrupo = $fotoGrupo;
	}
	
	/**
	 * @param unknown_type $fotoGrupoID
	 */
	public function setFotoGrupoID($fotoGrupoID) {
		$this->fotoGrupoID = $fotoGrupoID;
	}
	
	/**
	 * @param unknown_type $fotoQ
	 */
	public function setFotoQ($fotoQ) {
		$this->fotoQ = $fotoQ;
	}
	
	/**
	 * @param unknown_type $nome
	 */
	public function setNome($nome) {
		$this->nome = Idiomas::setTexto($this->nome,$this->lang,$nome);
	}
	
	/**
	 * @param unknown_type $texto
	 */
	public function setTexto($texto) {
		$this->texto = Idiomas::setTexto($this->texto,$this->lang,$texto);
	}

	
}
?>