<?php
require_once(realpath(dirname(__FILE__)) . '/../Domain/Artigo.php');

class ArtigoClasse {
	public $artigoClasseID;
	public $nome;
	public $lang;
	/**
	 * @AssociationType Domain.Artigo
	 * @AssociationMultiplicity 0..*
	 */
	public $artigos;
	
	
	public function getArtigoClasseID() {
		return $this->artigoClasseID;
	}
	
	public function setArtigoClasseID($artigoClasseID) {
		$this->artigoClasseID = $artigoClasseID;
	}
	
	public function getArtigos() {
		return $this->artigos;
	}
	
	public function setArtigos(Collection $artigos) {
		$this->artigos = $artigos;
	}
	
	public function addArtigo(Artigo $artigo){
		$this->artigos->add($artigo);
	}
	
	public function getNome() {
		return Idiomas::getTexto($this->nome,$this->lang);
	}
	
	public function setNome($nome) {
		$this->nome = Idiomas::setTexto($this->nome,$this->lang,$nome);
	}

}
?>