<?php
require_once(realpath(dirname(__FILE__)) . '/../Domain/FotoGrupo.php');

class Foto {
	public $fotoID;
	public $fotoGrupoID;
	public $nome;
	public $foto;
	public $fotoQ;
	public $ordem;
	public $lang;
	/**
	 * @AssociationType Domain.FotoGrupo
	 * @AssociationMultiplicity 1
	 */
	public $fotoGrupo;
	
	public function getFoto() {
		return $this->foto;
	}
	
	public function setFoto($foto) {
		$this->foto = $foto;
	}
	
	public function getFotoGrupo() {
		return $this->fotoGrupo;
	}
	
	public function setFotoGrupo($fotoGrupo) {
		$this->fotoGrupo = $fotoGrupo;
	}
	
	public function getFotoGrupoID() {
		return $this->fotoGrupoID;
	}
	
	public function setFotoGrupoID($fotoGrupoID) {
		$this->fotoGrupoID = $fotoGrupoID;
	}
	
	public function getFotoID() {
		return $this->fotoID;
	}
	
	public function setFotoID($fotoID) {
		$this->fotoID = $fotoID;
	}
	
	public function getFotoQ() {
		return $this->fotoQ;
	}
	
	public function setFotoQ($fotoQ) {
		$this->fotoQ = $fotoQ;
	}
	
	public function getNome() {
		return Idiomas::getTexto($this->nome,$this->lang);
	}
	
	public function setNome($nome) {
		$this->nome = Idiomas::setTexto($this->nome,$this->lang,$nome);
	}
	/**
	 * @return unknown
	 */
	public function getOrdem() {
		return $this->ordem;
	}
	
	/**
	 * @param unknown_type $ordem
	 */
	public function setOrdem($ordem) {
		$this->ordem = $ordem;
	}


}
?>