<?php
require_once(realpath(dirname(__FILE__)) . '/../Domain/Area.php');
require_once(realpath(dirname(__FILE__)) . '/../Domain/Acomodacao.php');
require_once(realpath(dirname(__FILE__)) . '/../Domain/Artigo.php');
require_once(realpath(dirname(__FILE__)) . '/../Domain/Foto.php');

class FotoGrupo {
	public $fotoGrupoID;
	public $nome;
	public $lang;
	/**
	 * @AssociationType Domain.Area
	 * @AssociationMultiplicity 0..1
	 */
	public $area;
	/**
	 * @AssociationType Domain.Foto
	 * @AssociationMultiplicity *
	 */
	public $fotos;
	/**
	 * @AssociationType Domain.Acomodacao
	 * @AssociationMultiplicity 0..1
	 */
	public $acomodacao;
	/**
	 * @AssociationType Domain.Artigo
	 * @AssociationMultiplicity 0..1
	 */
	public $artigo;


	
	public function getAcomodacao() {
		return $this->acomodacao;
	}
	
	public function setAcomodacao(Acomodacao $acomodacao) {
		$this->acomodacao = $acomodacao;
	}
	
	public function getArea() {
		return $this->area;
	}
	
	public function setArea(Area $area) {
		$this->area = $area;
	}
	
	public function getArtigo() {
		return $this->artigo;
	}
	
	public function setArtigo(Artigo $artigo) {
		$this->artigo = $artigo;
	}
	
	public function getFotoGrupoID() {
		return $this->fotoGrupoID;
	}
	
	public function setFotoGrupoID($fotoGrupoID) {
		$this->fotoGrupoID = $fotoGrupoID;
	}
	
	public function getFotos() {
		return $this->fotos;
	}
	
	public function setFotos(Collection $fotos) {
		$this->fotos = $fotos;
	}
	
	public function addFoto(Foto $foto) {
		$this->fotos->addf($foto);
	}
	
	
	public function getNome() {
		return Idiomas::getTexto($this->nome,$this->lang);
	}
	
	public function setNome($nome) {
		$this->nome = Idiomas::setTexto($this->nome,$this->lang,$nome);
	}

}
?>