<?php

/****************************************************************************************
* LiveZilla definitions.inc.php
* 
* Copyright 2001-2009 SPAUN Power GmbH
* All rights reserved.
* LiveZilla is a registered trademark.
* 
***************************************************************************************/ 

define("VERSION","3.1.8.1");
define("PHP_NEEDED_MAJOR",4);
define("PHP_NEEDED_MINOR",2);
define("PHP_NEEDED_BUILD",1);
define("PROTOCOL","livezilla");
define("USER_ID_LENGTH",7);
define("DATA_ACCESS_ATTEMPTS",5);
define("DATA_ACCESS_LENGTH",4096);
define("DATA_ITEM_LOADS",25);
define("DATA_LIFETIME",2592000);
define("DATA_URL_STORAGE_AMOUNT",250);
define("MAX_POST_SIZE_SAFE_MODE",512000);
define("MAX_UPLOAD_SIZE_SAFE_MODE",200000);
define("MAX_MAIL_INTERVAL",60);
define("MAX_RATES_PER_DAY",3);
define("ACTIVE_TIME",1800);
define("QUITTANCE_TIME",300);
define("ALLOCATION_MODE_PRESELECT",0);
define("ALLOCATION_MODE_ALL",1);
define("CONVERSATION_STATUS_CLOSED","closed");
define("CONVERSATION_STATUS_STARTED","started");
define("CONVERSATION_STATUS_ACTIVE","active");
define("CONVERSATION_STATUS_WAITING","waiting");
define("CONVERSATION_STATUS_DECLINED","declined");
define("CALLER_TYPE_INTERNAL","intern");
define("CALLER_TYPE_EXTERNAL","extern");
define("CALLER_TYPE_TRACK","track");
define("PERMISSION_FULL",2);
define("PERMISSION_RELATED",1);
define("PERMISSION_NONE",0);
define("PERMISSION_MESSAGES",0);
define("PERMISSION_RATINGS",1);
define("PERMISSION_CHATS",2);
define("PERMISSION_RESOURCES",3);
define("CHAT_CLOSED",1);
define("CHAT_DECLINED",0);
define("CHAT_STATUS_OPEN",0);
define("CHAT_STATUS_WAITING",1);
define("CHAT_STATUS_ACTIVE",2);
define("USER_STATUS_ONLINE",0);
define("USER_STATUS_BUSY",1);
define("USER_STATUS_OFFLINE",2);
define("USER_STATUS_AWAY",3);
define("USER_TYPE_EXTERN",0);
define("USER_TYPE_INTERN",1);
define("USER_LEVEL_ADMIN",1);
define("GROUP_STATUS_AVAILABLE",0);
define("GROUP_STATUS_BUSY",1);
define("GROUP_STATUS_UNAVAILABLE",2);
define("POST_ACTION_VALUE_SPLITTER","<<>>");
define("POST_ACTION_ADD",0);
define("POST_ACTION_EDIT",1);
define("POST_ACTION_REMOVE",2);
define("DATA_RESPONSE_TYPE_STATIC",2);
define("DATA_RESPONSE_TYPE_BASIC",1);
define("DATA_RESPONSE_TYPE_KEEP_ALIVE",0);
define("GROUP_EVERYONE_INTERN","everyoneintern");
define("GROUP_EVERYONE_EXTERN","everyoneextern");
define("BROWSER_TYPE_BROWSER",0);
define("BROWSER_TYPE_CHAT",1);
define("TRACKING_PAGE_TYPE_CHAT","Chat");
define("LOGIN_REPLY_BAD_COMBINATION",0);
define("LOGIN_REPLY_SUCCEEDED",1);
define("LOGIN_REPLY_ALREADY_ONLINE",2);
define("LOGIN_REPLY_PHPVERSION",3);
define("LOGIN_REPLY_SCRIPTVERSION",4);
define("LOGIN_REPLY_CHANGE_PASS",5);
define("LOGIN_REPLY_ADMIN",6);
define("LOGIN_REPLY_SAFE_MODE",7);
define("LOGIN_REPLY_NOADMIN",9);
define("LOGIN_REPLY_DEACTIVATED",10);
define("LOGIN_REPLY_IDLE",11);
define("LOGIN_REPLY_CMOD",12);
define("LOGIN_REPLY_DB",13);
define("FILTER_EXERTION_BLACK",0);
define("FILTER_EXERTION_WHITE",1);
define("FILTER_TYPE_ACTIVE",1);
define("FILTER_TYPE_INACTIVE",0);
define("FLOOD_PROTECTION_SESSIONS",15);
define("FLOOD_PROTECTION_TIME",60);
define("FILE_ERROR_SAVE",1);
define("REQUEST_STATUS_ACTIVE",0);
define("REQUEST_STATUS_ACCEPTED",1);
define("REQUEST_STATUS_DECLINED",2);
define("CONFIG_LIVEZILLA_GEO","https://ssl.livezilla.net/geo/resolute/");
define("CONFIG_LIVEZILLA_FAQ","http://www.livezilla.net/faq/");
define("EXTERN_ACTION_RELOAD_GROUPS","reloadgroups");
define("EXTERN_ACTION_LOGIN","login");
define("EXTERN_ACTION_LISTEN","listen");
define("EXTERN_ACTION_FILE_UPLOAD","file_upload");
define("EXTERN_ACTION_MAIL","mail");
define("EXTERN_ACTION_RATE","rate");
define("INTERN_ACTION_LISTEN","listen");
define("INTERN_ACTION_LOGIN","login");
define("INTERN_ACTION_SET_MANAGEMENT","update_management");
define("INTERN_ACTION_GET_CONFIG","server_config");
define("INTERN_ACTION_SET_CONFIG","set_config");
define("INTERN_ACTION_DATABASE_TEST","database_test");
define("INTERN_ACTION_CREATE_TABLES","create_tables");
define("INTERN_ACTION_INIT_UPLOAD","init_upload");
define("INTERN_ACTION_CONNECTION_TEST","contest");
define("INTERN_ACTION_SEND_FILE","send_file");
define("INTERN_ACTION_REMOVE_FILE","remove_file");
define("INTERN_ACTION_SET_AVAILABILITY","set_availability");
define("INTERN_ACTION_SET_IDLE","set_idle");
define("INTERN_ACTION_GET_BANNER_LIST","get_banner_list");
define("INTERN_ACTION_SEND_RESOURCES","send_resources");
define("XML_CLIP_NULL","N");
define("DATA_SOURCE_FILE",0);
define("DATA_SOURCE_DATABASE",1);
define("DATABASE_DATA","data");
define("DATABASE_INFO","info");
define("DATABASE_CHATS","chats");
define("DATABASE_INTERNAL","internal");
define("DATABASE_RESOURCES","res");
define("OFFLINE_MESSAGE_MODE_DEFAULT",0);
define("OFFLINE_MESSAGE_MODE_HTTP",1);
define("OFFLINE_MESSAGE_MODE_EMAIL",2);
?>